#!/bin/sh

# interrupt normal dash startup
killall rcS
# shut down BIVL middeware
killall bivlcored
killall cat

# stop movie that launched us
/psp/stop_flashplayer.sh

# start cron to get the watchdog and time sync going
/usr/sbin/crond -e /etc/cron/crontabs

# start sshd if user wants
if [ -e /mnt/usb/start_sshd ] || [ -e /psp/start_sshd ]; then
  /usr/chumby/scripts/start_sshd.sh
fi

# start httpd if user wants
if [ -e /mnt/usb/start_httpd] || [ -e /psp/start_httpd ]; then
  /usr/sbin/httpd -h /www
fi

# start the opening animation in background
touch /tmp/wait_for_opening
/psp/start_opening_anim.sh &

# wait for the network to come up, or 10 seconds
/usr/chumby/scripts/wait_for_link

# wait until the opening animation says it's done
/usr/chumby/scripts/wait_for_opening
/psp/stop_flashplayer.sh

# launch debugchumby if user has one
if [ -e /mnt/usb/debugchumby ]; then
  /mnt/usb/debugchumby
fi

# set the base path to our local controlpanel
echo "/psp/controlpanel.swf" > /tmp/cp_path

# start the Control Panel
/psp/start_control_panel &

